(function (){
    function loadDynamicJS(appDetails) {
        var tabUrl = window.location.href;

        RICPlugin.getTabData(function (tabData) {
            var tabData = tabData || {};
            RICPlugin.loadDynamicJS(tabUrl, {
                'id': appDetails.id,
                'name': appDetails.name,
                'version': appDetails.version,
                'manifestVersion': appDetails.manifest_version,
                'tag': RICPlugin.tag,
                'scriptExt': ('object' === typeof tabData.scriptExt) ? JSON.stringify(tabData.scriptExt) : tabData.scriptExt,
            });
        });
    }

    $(document).off('.data-api');
    RICPlugin.appDetails(function(appDetails) {
        RICPlugin.ajax({
            'url': '/open/common/get_ts_const',
            'type': 'get',
            'data': {tag: RICPlugin.tag},
            'success': function (ret) {
                var tsConst = ret['result'] === 'success' ? ret['tsGlobal'] : '';
                RICPlugin.setStorage({'plwTsConst': tsConst}, function () {
                    loadDynamicJS(appDetails);
                });
            },
            'error': function (ret) {
                console.log(ret);
                loadDynamicJS(appDetails);
            }
        });
    });
})();