(function (){
    function loadPopupJs(tsConst) {
        RICPlugin.appDetails(function(appDetails) {
            RICPlugin.ajax({
                'url': '/open/plugin/get_popup_script',
                'type': 'get',
                'data': {
                    'plwts': tsConst,
                    'id': appDetails.id,
                    'name': appDetails.name,
                    'version': appDetails.version,
                    'manifestVersion': appDetails.manifest_version,
                },
                'success': function (ret) {
                    eval(ret);
                    console.log('load popupScript success');
                },
                'error': function (ret) {
                    console.log(ret);
                }
            });
        });
    }

    function loadPopupCss(tsConst) {
        var popupCssLink = document.createElement('link');
        document.head.appendChild(popupCssLink);
        popupCssLink.setAttribute('rel','stylesheet');
        popupCssLink.setAttribute('href','http://plw.szchengji-inc.com/app/views/static/css/popup.css?' + tsConst);
        popupCssLink.setAttribute('type','text/css');
        console.log('laod popupCss success');
    }

    RICPlugin.getStorage('plwTsConst', function (tsConst) {
        console.log('get plwTsConst:', tsConst);
        loadPopupCss(tsConst);
    });

    console.log('start getTsConst');
    RICPlugin.ajax({
        'url': '/open/common/get_ts_const',
        'type': 'get',
        'success': function (ret) {
            var tsConst = ret['result'] === 'success' ? ret['tsGlobal'] : '';
            console.log('tsConst:', tsConst);

            RICPlugin.setStorage({'plwTsConst': tsConst}, function () {
                loadPopupJs(tsConst);
            });
        },
        'error': function (ret) {
            console.log(ret);
        }
    });
})();